package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  Uri,
  NlbArn,
  NlbName,
  VpcLinkId,
  ApiGatewayId,
  StageName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApiGatewayProxyConfig(
    apiGatewayId: Optional[ApiGatewayId] = Optional.Absent,
    endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = Optional.Absent,
    nlbArn: Optional[NlbArn] = Optional.Absent,
    nlbName: Optional[NlbName] = Optional.Absent,
    proxyUrl: Optional[Uri] = Optional.Absent,
    stageName: Optional[StageName] = Optional.Absent,
    vpcLinkId: Optional[VpcLinkId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyConfig = {
    import ApiGatewayProxyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyConfig
      .builder()
      .optionallyWith(
        apiGatewayId.map(value => ApiGatewayId.unwrap(value): java.lang.String)
      )(_.apiGatewayId)
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        nlbArn.map(value => NlbArn.unwrap(value): java.lang.String)
      )(_.nlbArn)
      .optionallyWith(
        nlbName.map(value => NlbName.unwrap(value): java.lang.String)
      )(_.nlbName)
      .optionallyWith(
        proxyUrl.map(value => Uri.unwrap(value): java.lang.String)
      )(_.proxyUrl)
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        vpcLinkId.map(value => VpcLinkId.unwrap(value): java.lang.String)
      )(_.vpcLinkId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyConfig.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyConfig
      .wrap(buildAwsValue())
}
object ApiGatewayProxyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyConfig =
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyConfig(
        apiGatewayId.map(value => value),
        endpointType.map(value => value),
        nlbArn.map(value => value),
        nlbName.map(value => value),
        proxyUrl.map(value => value),
        stageName.map(value => value),
        vpcLinkId.map(value => value)
      )
    def apiGatewayId: Optional[ApiGatewayId]
    def endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ]
    def nlbArn: Optional[NlbArn]
    def nlbName: Optional[NlbName]
    def proxyUrl: Optional[Uri]
    def stageName: Optional[StageName]
    def vpcLinkId: Optional[VpcLinkId]
    def getApiGatewayId: ZIO[Any, AwsError, ApiGatewayId] =
      AwsError.unwrapOptionField("apiGatewayId", apiGatewayId)
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getNlbArn: ZIO[Any, AwsError, NlbArn] =
      AwsError.unwrapOptionField("nlbArn", nlbArn)
    def getNlbName: ZIO[Any, AwsError, NlbName] =
      AwsError.unwrapOptionField("nlbName", nlbName)
    def getProxyUrl: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("proxyUrl", proxyUrl)
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getVpcLinkId: ZIO[Any, AwsError, VpcLinkId] =
      AwsError.unwrapOptionField("vpcLinkId", vpcLinkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyConfig
  ) extends zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyConfig.ReadOnly {
    override val apiGatewayId: Optional[ApiGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.apiGatewayId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApiGatewayId(value)
      )
    override val endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
          .wrap(value)
      )
    override val nlbArn: Optional[NlbArn] = zio.aws.core.internal
      .optionalFromNullable(impl.nlbArn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NlbArn(value)
      )
    override val nlbName: Optional[NlbName] = zio.aws.core.internal
      .optionalFromNullable(impl.nlbName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NlbName(value)
      )
    override val proxyUrl: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.proxyUrl())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Uri(value)
      )
    override val stageName: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.StageName(value)
      )
    override val vpcLinkId: Optional[VpcLinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcLinkId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcLinkId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyConfig
  ): zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyConfig.ReadOnly =
    new Wrapper(impl)
}
