package zio.aws.migrationhubrefactorspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceState {
  def unwrap: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState
}
object ServiceState {
  def wrap(
      value: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState
  ): zio.aws.migrationhubrefactorspaces.model.ServiceState = value match {
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhubrefactorspaces.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING
      extends zio.aws.migrationhubrefactorspaces.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.CREATING
  }
  case object ACTIVE
      extends zio.aws.migrationhubrefactorspaces.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.ACTIVE
  }
  case object DELETING
      extends zio.aws.migrationhubrefactorspaces.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.DELETING
  }
  case object FAILED
      extends zio.aws.migrationhubrefactorspaces.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceState.FAILED
  }
}
