package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  RouteId,
  EnvironmentId,
  ApplicationId
}
import scala.jdk.CollectionConverters.*
final case class GetRouteRequest(
    applicationIdentifier: ApplicationId,
    environmentIdentifier: EnvironmentId,
    routeIdentifier: RouteId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteRequest = {
    import GetRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .routeIdentifier(RouteId.unwrap(routeIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetRouteRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetRouteRequest
      .wrap(buildAwsValue())
}
object GetRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.GetRouteRequest =
      zio.aws.migrationhubrefactorspaces.model.GetRouteRequest(
        applicationIdentifier,
        environmentIdentifier,
        routeIdentifier
      )
    def applicationIdentifier: ApplicationId
    def environmentIdentifier: EnvironmentId
    def routeIdentifier: RouteId
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getRouteIdentifier: ZIO[Any, Nothing, RouteId] =
      ZIO.succeed(routeIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.GetRouteRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val routeIdentifier: RouteId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .RouteId(impl.routeIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteRequest
  ): zio.aws.migrationhubrefactorspaces.model.GetRouteRequest.ReadOnly =
    new Wrapper(impl)
}
