package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.ResourcePolicyIdentifier
import scala.jdk.CollectionConverters.*
final case class DeleteResourcePolicyRequest(
    identifier: ResourcePolicyIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
      .builder()
      .identifier(ResourcePolicyIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest =
      zio.aws.migrationhubrefactorspaces.model
        .DeleteResourcePolicyRequest(identifier)
    def identifier: ResourcePolicyIdentifier
    def getIdentifier: ZIO[Any, Nothing, ResourcePolicyIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest.ReadOnly {
    override val identifier: ResourcePolicyIdentifier =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ResourcePolicyIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
  ): zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
