package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  TagMapKeyString,
  EnvironmentId,
  Description,
  ClientToken,
  TagMapValueString,
  ServiceName,
  ApplicationId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateServiceRequest(
    applicationIdentifier: ApplicationId,
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    endpointType: zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType,
    environmentIdentifier: EnvironmentId,
    lambdaEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput
    ] = Optional.Absent,
    name: ServiceName,
    tags: Optional[Map[TagMapKeyString, TagMapValueString]] = Optional.Absent,
    urlEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput
    ] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateServiceRequest = {
    import CreateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateServiceRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .endpointType(endpointType.unwrap)
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .optionallyWith(lambdaEndpoint.map(value => value.buildAwsValue()))(
        _.lambdaEndpoint
      )
      .name(ServiceName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString.unwrap(
                key
              ): java.lang.String) -> (TagMapValueString.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(urlEndpoint.map(value => value.buildAwsValue()))(
        _.urlEndpoint
      )
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest
      .wrap(buildAwsValue())
}
object CreateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest =
      zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest(
        applicationIdentifier,
        clientToken.map(value => value),
        description.map(value => value),
        endpointType,
        environmentIdentifier,
        lambdaEndpoint.map(value => value.asEditable),
        name,
        tags.map(value => value),
        urlEndpoint.map(value => value.asEditable),
        vpcId.map(value => value)
      )
    def applicationIdentifier: ApplicationId
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def endpointType
        : zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
    def environmentIdentifier: EnvironmentId
    def lambdaEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput.ReadOnly
    ]
    def name: ServiceName
    def tags: Optional[Map[TagMapKeyString, TagMapValueString]]
    def urlEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput.ReadOnly
    ]
    def vpcId: Optional[VpcId]
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointType: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
    ] = ZIO.succeed(endpointType)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getLambdaEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaEndpoint", lambdaEndpoint)
    def getName: ZIO[Any, Nothing, ServiceName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUrlEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput.ReadOnly
    ] = AwsError.unwrapOptionField("urlEndpoint", urlEndpoint)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateServiceRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ClientToken(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Description(value)
      )
    override val endpointType
        : zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType =
      zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
        .wrap(impl.endpointType())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val lambdaEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaEndpoint())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput.wrap(value)
      )
    override val name: ServiceName =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ServiceName(impl.name())
    override val tags: Optional[Map[TagMapKeyString, TagMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapKeyString(
                  key
                ) -> zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapValueString(value)
            })
            .toMap
        )
    override val urlEndpoint: Optional[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.urlEndpoint())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.UrlEndpointInput.wrap(value)
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateServiceRequest
  ): zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest.ReadOnly =
    new Wrapper(impl)
}
