package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  Timestamp,
  EnvironmentId,
  ResourceArn,
  ServiceName,
  ApplicationId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeleteServiceResponse(
    applicationId: Option[ApplicationId] = None,
    arn: Option[ResourceArn] = None,
    environmentId: Option[EnvironmentId] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    name: Option[ServiceName] = None,
    serviceId: Option[ServiceId] = None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.ServiceState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse = {
    import DeleteServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse
      .wrap(buildAwsValue())
}
object DeleteServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse =
      zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        environmentId.map(value => value),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        serviceId.map(value => value),
        state.map(value => value)
      )
    def applicationId: Option[ApplicationId]
    def arn: Option[ResourceArn]
    def environmentId: Option[EnvironmentId]
    def lastUpdatedTime: Option[Timestamp]
    def name: Option[ServiceName]
    def serviceId: Option[ServiceId]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.ServiceState]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ServiceState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Option[ServiceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceName(value)
      )
    override val serviceId: Option[ServiceId] = scala
      .Option(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.ServiceState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ServiceState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteServiceResponse
  ): zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly =
    new Wrapper(impl)
}
