package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  Timestamp,
  ResourceArn,
  RouteId,
  ApplicationId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeleteRouteResponse(
    applicationId: Option[ApplicationId] = None,
    arn: Option[ResourceArn] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    routeId: Option[RouteId] = None,
    serviceId: Option[ServiceId] = None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.RouteState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteRouteResponse = {
    import DeleteRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteRouteResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        routeId.map(value => RouteId.unwrap(value): java.lang.String)
      )(_.routeId)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse
      .wrap(buildAwsValue())
}
object DeleteRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse =
      zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        lastUpdatedTime.map(value => value),
        routeId.map(value => value),
        serviceId.map(value => value),
        state.map(value => value)
      )
    def applicationId: Option[ApplicationId]
    def arn: Option[ResourceArn]
    def lastUpdatedTime: Option[Timestamp]
    def routeId: Option[RouteId]
    def serviceId: Option[ServiceId]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.RouteState]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getRouteId: ZIO[Any, AwsError, RouteId] =
      AwsError.unwrapOptionField("routeId", routeId)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteRouteResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val routeId: Option[RouteId] = scala
      .Option(impl.routeId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.RouteId(value)
      )
    override val serviceId: Option[ServiceId] = scala
      .Option(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.RouteState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.RouteState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteRouteResponse
  ): zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly =
    new Wrapper(impl)
}
