package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  EnvironmentId,
  ApplicationId
}
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationRequest(
    applicationIdentifier: ApplicationId,
    environmentIdentifier: EnvironmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest =
      zio.aws.migrationhubrefactorspaces.model
        .DeleteApplicationRequest(applicationIdentifier, environmentIdentifier)
    def applicationIdentifier: ApplicationId
    def environmentIdentifier: EnvironmentId
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationRequest
  ): zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
