package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  TagMapValueString,
  TagMapKeyString
}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse =
      zio.aws.migrationhubrefactorspaces.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListTagsForResourceResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListTagsForResourceResponse
  ): zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
