package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  TagMapKeyString,
  EnvironmentName,
  Description,
  ClientToken,
  TagMapValueString
}
import scala.jdk.CollectionConverters.*
final case class CreateEnvironmentRequest(
    clientToken: Option[ClientToken] = None,
    description: Option[Description] = None,
    name: EnvironmentName,
    networkFabricType: zio.aws.migrationhubrefactorspaces.model.NetworkFabricType,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateEnvironmentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .networkFabricType(networkFabricType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest
      .wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest =
      zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest(
        clientToken.map(value => value),
        description.map(value => value),
        name,
        networkFabricType,
        tags.map(value => value)
      )
    def clientToken: Option[ClientToken]
    def description: Option[Description]
    def name: EnvironmentName
    def networkFabricType
        : zio.aws.migrationhubrefactorspaces.model.NetworkFabricType
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getNetworkFabricType: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhubrefactorspaces.model.NetworkFabricType
    ] = ZIO.succeed(networkFabricType)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateEnvironmentRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ClientToken(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Description(value)
      )
    override val name: EnvironmentName =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentName(impl.name())
    override val networkFabricType
        : zio.aws.migrationhubrefactorspaces.model.NetworkFabricType =
      zio.aws.migrationhubrefactorspaces.model.NetworkFabricType
        .wrap(impl.networkFabricType())
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateEnvironmentRequest
  ): zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
