package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  AdditionalDetailsValue,
  ErrorMessage,
  AccountId,
  ResourceIdentifier,
  AdditionalDetailsKey
}
import scala.jdk.CollectionConverters.*
final case class ErrorResponse(
    accountId: Option[AccountId] = None,
    additionalDetails: Option[
      Map[AdditionalDetailsKey, AdditionalDetailsValue]
    ] = None,
    code: Option[zio.aws.migrationhubrefactorspaces.model.ErrorCode] = None,
    message: Option[ErrorMessage] = None,
    resourceIdentifier: Option[ResourceIdentifier] = None,
    resourceType: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResourceType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse = {
    import ErrorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        additionalDetails.map(value =>
          value
            .map({ case (key, value) =>
              (AdditionalDetailsKey.unwrap(
                key
              ): java.lang.String) -> (AdditionalDetailsValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.additionalDetails)
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        resourceIdentifier.map(value =>
          ResourceIdentifier.unwrap(value): java.lang.String
        )
      )(_.resourceIdentifier)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(buildAwsValue())
}
object ErrorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.ErrorResponse =
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse(
        accountId.map(value => value),
        additionalDetails.map(value => value),
        code.map(value => value),
        message.map(value => value),
        resourceIdentifier.map(value => value),
        resourceType.map(value => value)
      )
    def accountId: Option[AccountId]
    def additionalDetails
        : Option[Map[AdditionalDetailsKey, AdditionalDetailsValue]]
    def code: Option[zio.aws.migrationhubrefactorspaces.model.ErrorCode]
    def message: Option[ErrorMessage]
    def resourceIdentifier: Option[ResourceIdentifier]
    def resourceType
        : Option[zio.aws.migrationhubrefactorspaces.model.ErrorResourceType]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAdditionalDetails: ZIO[Any, AwsError, Map[
      AdditionalDetailsKey,
      AdditionalDetailsValue
    ]] = AwsError.unwrapOptionField("additionalDetails", additionalDetails)
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getResourceIdentifier: ZIO[Any, AwsError, ResourceIdentifier] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val additionalDetails
        : Option[Map[AdditionalDetailsKey, AdditionalDetailsValue]] = scala
      .Option(impl.additionalDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives
              .AdditionalDetailsKey(
                key
              ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .AdditionalDetailsValue(value)
          })
          .toMap
      )
    override val code
        : Option[zio.aws.migrationhubrefactorspaces.model.ErrorCode] = scala
      .Option(impl.code())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorCode.wrap(value)
      )
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ErrorMessage(value)
      )
    override val resourceIdentifier: Option[ResourceIdentifier] = scala
      .Option(impl.resourceIdentifier())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .ResourceIdentifier(value)
      )
    override val resourceType
        : Option[zio.aws.migrationhubrefactorspaces.model.ErrorResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ErrorResourceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorResponse
  ): zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly =
    new Wrapper(impl)
}
