package zio.aws.migrationhubrefactorspaces.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode
  ): zio.aws.migrationhubrefactorspaces.model.ErrorCode = value match {
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.INVALID_RESOURCE_STATE =>
      val r = INVALID_RESOURCE_STATE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED =>
      val r = RESOURCE_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_CREATION_FAILURE =>
      val r = RESOURCE_CREATION_FAILURE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_UPDATE_FAILURE =>
      val r = RESOURCE_UPDATE_FAILURE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE =>
      val r = SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_DELETION_FAILURE =>
      val r = RESOURCE_DELETION_FAILURE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_RETRIEVAL_FAILURE =>
      val r = RESOURCE_RETRIEVAL_FAILURE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_IN_USE =>
      val r = RESOURCE_IN_USE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_NOT_FOUND =>
      val r = RESOURCE_NOT_FOUND
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.STATE_TRANSITION_FAILURE =>
      val r = STATE_TRANSITION_FAILURE
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.REQUEST_LIMIT_EXCEEDED =>
      val r = REQUEST_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.NOT_AUTHORIZED =>
      val r = NOT_AUTHORIZED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INVALID_RESOURCE_STATE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.INVALID_RESOURCE_STATE
  }
  case object RESOURCE_LIMIT_EXCEEDED
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_LIMIT_EXCEEDED
  }
  case object RESOURCE_CREATION_FAILURE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_CREATION_FAILURE
  }
  case object RESOURCE_UPDATE_FAILURE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_UPDATE_FAILURE
  }
  case object SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE
  }
  case object RESOURCE_DELETION_FAILURE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_DELETION_FAILURE
  }
  case object RESOURCE_RETRIEVAL_FAILURE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_RETRIEVAL_FAILURE
  }
  case object RESOURCE_IN_USE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_IN_USE
  }
  case object RESOURCE_NOT_FOUND
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.RESOURCE_NOT_FOUND
  }
  case object STATE_TRANSITION_FAILURE
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.STATE_TRANSITION_FAILURE
  }
  case object REQUEST_LIMIT_EXCEEDED
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.REQUEST_LIMIT_EXCEEDED
  }
  case object NOT_AUTHORIZED
      extends zio.aws.migrationhubrefactorspaces.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ErrorCode.NOT_AUTHORIZED
  }
}
