package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ApplicationName,
  Timestamp,
  EnvironmentId,
  ResourceArn,
  ApplicationId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationResponse(
    applicationId: Option[ApplicationId] = None,
    arn: Option[ResourceArn] = None,
    environmentId: Option[EnvironmentId] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    name: Option[ApplicationName] = None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.ApplicationState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationResponse = {
    import DeleteApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse
      .wrap(buildAwsValue())
}
object DeleteApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse =
      zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        environmentId.map(value => value),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def applicationId: Option[ApplicationId]
    def arn: Option[ResourceArn]
    def environmentId: Option[EnvironmentId]
    def lastUpdatedTime: Option[Timestamp]
    def name: Option[ApplicationName]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.ApplicationState]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApplicationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Option[ApplicationName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .ApplicationName(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.ApplicationState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ApplicationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteApplicationResponse
  ): zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
