package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  TagMapKeyString,
  AccountId,
  Timestamp,
  EnvironmentName,
  TransitGatewayId,
  EnvironmentId,
  Description,
  ResourceArn,
  TagMapValueString
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentResponse(
    arn: Option[ResourceArn] = None,
    createdTime: Option[Timestamp] = None,
    description: Option[Description] = None,
    environmentId: Option[EnvironmentId] = None,
    error: Option[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      None,
    lastUpdatedTime: Option[Timestamp] = None,
    name: Option[EnvironmentName] = None,
    networkFabricType: Option[
      zio.aws.migrationhubrefactorspaces.model.NetworkFabricType
    ] = None,
    ownerAccountId: Option[AccountId] = None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.EnvironmentState] =
      None,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None,
    transitGatewayId: Option[TransitGatewayId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentResponse = {
    import GetEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentResponse
      .builder()
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(networkFabricType.map(value => value.unwrap))(
        _.networkFabricType
      )
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse
      .wrap(buildAwsValue())
}
object GetEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse =
      zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse(
        arn.map(value => value),
        createdTime.map(value => value),
        description.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        networkFabricType.map(value => value),
        ownerAccountId.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        transitGatewayId.map(value => value)
      )
    def arn: Option[ResourceArn]
    def createdTime: Option[Timestamp]
    def description: Option[Description]
    def environmentId: Option[EnvironmentId]
    def error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def lastUpdatedTime: Option[Timestamp]
    def name: Option[EnvironmentName]
    def networkFabricType
        : Option[zio.aws.migrationhubrefactorspaces.model.NetworkFabricType]
    def ownerAccountId: Option[AccountId]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.EnvironmentState]
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def transitGatewayId: Option[TransitGatewayId]
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getNetworkFabricType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.NetworkFabricType
    ] = AwsError.unwrapOptionField("networkFabricType", networkFabricType)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.EnvironmentState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly {
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Description(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Option[EnvironmentName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .EnvironmentName(value)
      )
    override val networkFabricType
        : Option[zio.aws.migrationhubrefactorspaces.model.NetworkFabricType] =
      scala
        .Option(impl.networkFabricType())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.NetworkFabricType.wrap(value)
        )
    override val ownerAccountId: Option[AccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.EnvironmentState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.EnvironmentState.wrap(value)
        )
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
    override val transitGatewayId: Option[TransitGatewayId] = scala
      .Option(impl.transitGatewayId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .TransitGatewayId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentResponse
  ): zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
