package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  AccountId,
  Timestamp,
  Ec2TagValue,
  CidrBlock,
  EnvironmentId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class EnvironmentVpc(
    accountId: Option[AccountId] = None,
    cidrBlocks: Option[Iterable[CidrBlock]] = None,
    createdTime: Option[Timestamp] = None,
    environmentId: Option[EnvironmentId] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    vpcId: Option[VpcId] = None,
    vpcName: Option[Ec2TagValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc = {
    import EnvironmentVpc.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        cidrBlocks.map(value =>
          value.map { item =>
            CidrBlock.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cidrBlocks)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        vpcName.map(value => Ec2TagValue.unwrap(value): java.lang.String)
      )(_.vpcName)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc
      .wrap(buildAwsValue())
}
object EnvironmentVpc {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc =
      zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc(
        accountId.map(value => value),
        cidrBlocks.map(value => value),
        createdTime.map(value => value),
        environmentId.map(value => value),
        lastUpdatedTime.map(value => value),
        vpcId.map(value => value),
        vpcName.map(value => value)
      )
    def accountId: Option[AccountId]
    def cidrBlocks: Option[List[CidrBlock]]
    def createdTime: Option[Timestamp]
    def environmentId: Option[EnvironmentId]
    def lastUpdatedTime: Option[Timestamp]
    def vpcId: Option[VpcId]
    def vpcName: Option[Ec2TagValue]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCidrBlocks: ZIO[Any, AwsError, List[CidrBlock]] =
      AwsError.unwrapOptionField("cidrBlocks", cidrBlocks)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcName: ZIO[Any, AwsError, Ec2TagValue] =
      AwsError.unwrapOptionField("vpcName", vpcName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
  ) extends zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val cidrBlocks: Option[List[CidrBlock]] = scala
      .Option(impl.cidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhubrefactorspaces.model.primitives.CidrBlock(item)
        }.toList
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(value)
      )
    override val vpcName: Option[Ec2TagValue] = scala
      .Option(impl.vpcName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Ec2TagValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
  ): zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly =
    new Wrapper(impl)
}
