package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentVpcsResponse(
    environmentVpcList: Option[
      Iterable[zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse = {
    import ListEnvironmentVpcsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
      .builder()
      .optionallyWith(
        environmentVpcList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVpcList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
      .wrap(buildAwsValue())
}
object ListEnvironmentVpcsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse =
      zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse(
        environmentVpcList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def environmentVpcList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getEnvironmentVpcList: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentVpcList", environmentVpcList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse.ReadOnly {
    override val environmentVpcList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly]
    ] = scala
      .Option(impl.environmentVpcList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
  ): zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse.ReadOnly =
    new Wrapper(impl)
}
