package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  TagMapKeyString,
  ApplicationName,
  AccountId,
  Timestamp,
  EnvironmentId,
  ResourceArn,
  TagMapValueString,
  ApplicationId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ApplicationSummary(
    apiGatewayProxy: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary
    ] = None,
    applicationId: Option[ApplicationId] = None,
    arn: Option[ResourceArn] = None,
    createdByAccountId: Option[AccountId] = None,
    createdTime: Option[Timestamp] = None,
    environmentId: Option[EnvironmentId] = None,
    error: Option[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      None,
    lastUpdatedTime: Option[Timestamp] = None,
    name: Option[ApplicationName] = None,
    ownerAccountId: Option[AccountId] = None,
    proxyType: Option[zio.aws.migrationhubrefactorspaces.model.ProxyType] =
      None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.ApplicationState] =
      None,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None,
    vpcId: Option[VpcId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
      .builder()
      .optionallyWith(apiGatewayProxy.map(value => value.buildAwsValue()))(
        _.apiGatewayProxy
      )
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(proxyType.map(value => value.unwrap))(_.proxyType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ApplicationSummary
      .wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ApplicationSummary =
      zio.aws.migrationhubrefactorspaces.model.ApplicationSummary(
        apiGatewayProxy.map(value => value.asEditable),
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        ownerAccountId.map(value => value),
        proxyType.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        vpcId.map(value => value)
      )
    def apiGatewayProxy: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly
    ]
    def applicationId: Option[ApplicationId]
    def arn: Option[ResourceArn]
    def createdByAccountId: Option[AccountId]
    def createdTime: Option[Timestamp]
    def environmentId: Option[EnvironmentId]
    def error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def lastUpdatedTime: Option[Timestamp]
    def name: Option[ApplicationName]
    def ownerAccountId: Option[AccountId]
    def proxyType: Option[zio.aws.migrationhubrefactorspaces.model.ProxyType]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.ApplicationState]
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def vpcId: Option[VpcId]
    def getApiGatewayProxy: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly
    ] = AwsError.unwrapOptionField("apiGatewayProxy", apiGatewayProxy)
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getProxyType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ProxyType
    ] = AwsError.unwrapOptionField("proxyType", proxyType)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApplicationState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
  ) extends zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly {
    override val apiGatewayProxy: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly
    ] = scala
      .Option(impl.apiGatewayProxy())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary
          .wrap(value)
      )
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Option[AccountId] = scala
      .Option(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Option[ApplicationName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .ApplicationName(value)
      )
    override val ownerAccountId: Option[AccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val proxyType
        : Option[zio.aws.migrationhubrefactorspaces.model.ProxyType] = scala
      .Option(impl.proxyType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ProxyType.wrap(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.ApplicationState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ApplicationState.wrap(value)
        )
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
  ): zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly =
    new Wrapper(impl)
}
