package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListServicesResponse(
    nextToken: Option[NextToken] = None,
    serviceSummaryList: Option[
      Iterable[zio.aws.migrationhubrefactorspaces.model.ServiceSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesResponse = {
    import ListServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListServicesResponse
      .wrap(buildAwsValue())
}
object ListServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListServicesResponse =
      zio.aws.migrationhubrefactorspaces.model.ListServicesResponse(
        nextToken.map(value => value),
        serviceSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def serviceSummaryList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceSummaryList: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceSummaryList", serviceSummaryList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
    override val serviceSummaryList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly]
    ] = scala
      .Option(impl.serviceSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhubrefactorspaces.model.ServiceSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesResponse
  ): zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly =
    new Wrapper(impl)
}
