package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  ServiceId,
  TagMapKeyString,
  AccountId,
  Timestamp,
  EnvironmentId,
  Description,
  ResourceArn,
  TagMapValueString,
  ServiceName,
  ApplicationId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetServiceResponse(
    applicationId: Option[ApplicationId] = None,
    arn: Option[ResourceArn] = None,
    createdByAccountId: Option[AccountId] = None,
    createdTime: Option[Timestamp] = None,
    description: Option[Description] = None,
    endpointType: Option[
      zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
    ] = None,
    environmentId: Option[EnvironmentId] = None,
    error: Option[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      None,
    lambdaEndpoint: Option[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig
    ] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    name: Option[ServiceName] = None,
    ownerAccountId: Option[AccountId] = None,
    serviceId: Option[ServiceId] = None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.ServiceState] = None,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None,
    urlEndpoint: Option[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig
    ] = None,
    vpcId: Option[VpcId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse = {
    import GetServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(lambdaEndpoint.map(value => value.buildAwsValue()))(
        _.lambdaEndpoint
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString.unwrap(
                key
              ): java.lang.String) -> (TagMapValueString.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(urlEndpoint.map(value => value.buildAwsValue()))(
        _.urlEndpoint
      )
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetServiceResponse
      .wrap(buildAwsValue())
}
object GetServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.GetServiceResponse =
      zio.aws.migrationhubrefactorspaces.model.GetServiceResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        description.map(value => value),
        endpointType.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        lambdaEndpoint.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        ownerAccountId.map(value => value),
        serviceId.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        urlEndpoint.map(value => value.asEditable),
        vpcId.map(value => value)
      )
    def applicationId: Option[ApplicationId]
    def arn: Option[ResourceArn]
    def createdByAccountId: Option[AccountId]
    def createdTime: Option[Timestamp]
    def description: Option[Description]
    def endpointType
        : Option[zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType]
    def environmentId: Option[EnvironmentId]
    def error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def lambdaEndpoint: Option[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly
    ]
    def lastUpdatedTime: Option[Timestamp]
    def name: Option[ServiceName]
    def ownerAccountId: Option[AccountId]
    def serviceId: Option[ServiceId]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.ServiceState]
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def urlEndpoint: Option[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly
    ]
    def vpcId: Option[VpcId]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getLambdaEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaEndpoint", lambdaEndpoint)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("name", name)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ServiceState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUrlEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("urlEndpoint", urlEndpoint)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Option[AccountId] = scala
      .Option(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Description(value)
      )
    override val endpointType
        : Option[zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType] =
      scala
        .Option(impl.endpointType())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType
            .wrap(value)
        )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val lambdaEndpoint: Option[
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly
    ] = scala
      .Option(impl.lambdaEndpoint())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig
          .wrap(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Option[ServiceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceName(value)
      )
    override val ownerAccountId: Option[AccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val serviceId: Option[ServiceId] = scala
      .Option(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.ServiceState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ServiceState.wrap(value)
      )
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
    override val urlEndpoint: Option[
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly
    ] = scala
      .Option(impl.urlEndpoint())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.wrap(value)
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetServiceResponse
  ): zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly =
    new Wrapper(impl)
}
