package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListRoutesResponse(
    nextToken: Option[NextToken] = None,
    routeSummaryList: Option[
      Iterable[zio.aws.migrationhubrefactorspaces.model.RouteSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesResponse = {
    import ListRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        routeSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routeSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse
      .wrap(buildAwsValue())
}
object ListRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse =
      zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse(
        nextToken.map(value => value),
        routeSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def routeSummaryList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRouteSummaryList: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("routeSummaryList", routeSummaryList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
    override val routeSummaryList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly]
    ] = scala
      .Option(impl.routeSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhubrefactorspaces.model.RouteSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesResponse
  ): zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly =
    new Wrapper(impl)
}
