package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.LambdaArn
import scala.jdk.CollectionConverters._
final case class LambdaEndpointInput(arn: LambdaArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointInput = {
    import LambdaEndpointInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointInput
      .builder()
      .arn(LambdaArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput
      .wrap(buildAwsValue())
}
object LambdaEndpointInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput =
      zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput(arn)
    def arn: LambdaArn
    def getArn: ZIO[Any, Nothing, LambdaArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointInput
  ) extends zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput.ReadOnly {
    override val arn: LambdaArn =
      zio.aws.migrationhubrefactorspaces.model.primitives.LambdaArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointInput
  ): zio.aws.migrationhubrefactorspaces.model.LambdaEndpointInput.ReadOnly =
    new Wrapper(impl)
}
