package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  TagMapKeyString,
  AccountId,
  Timestamp,
  PathResourceToIdValue,
  PathResourceToIdKey,
  EnvironmentId,
  ResourceArn,
  TagMapValueString,
  RouteId,
  ApplicationId,
  UriPath
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RouteSummary(
    appendSourcePath: Optional[Boolean] = Optional.Absent,
    applicationId: Optional[ApplicationId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent,
    createdByAccountId: Optional[AccountId] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    error: Optional[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      Optional.Absent,
    includeChildPaths: Optional[Boolean] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    methods: Optional[
      Iterable[zio.aws.migrationhubrefactorspaces.model.HttpMethod]
    ] = Optional.Absent,
    ownerAccountId: Optional[AccountId] = Optional.Absent,
    pathResourceToId: Optional[
      Map[PathResourceToIdKey, PathResourceToIdValue]
    ] = Optional.Absent,
    routeId: Optional[RouteId] = Optional.Absent,
    routeType: Optional[zio.aws.migrationhubrefactorspaces.model.RouteType] =
      Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent,
    sourcePath: Optional[UriPath] = Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.RouteState] =
      Optional.Absent,
    tags: Optional[Map[TagMapKeyString, TagMapValueString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummary = {
    import RouteSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummary
      .builder()
      .optionallyWith(appendSourcePath.map(value => value: java.lang.Boolean))(
        _.appendSourcePath
      )
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(includeChildPaths.map(value => value: java.lang.Boolean))(
        _.includeChildPaths
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        methods.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.methodsWithStrings)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        pathResourceToId.map(value =>
          value
            .map({ case (key, value) =>
              (PathResourceToIdKey.unwrap(
                key
              ): java.lang.String) -> (PathResourceToIdValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.pathResourceToId)
      .optionallyWith(
        routeId.map(value => RouteId.unwrap(value): java.lang.String)
      )(_.routeId)
      .optionallyWith(routeType.map(value => value.unwrap))(_.routeType)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(
        sourcePath.map(value => UriPath.unwrap(value): java.lang.String)
      )(_.sourcePath)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.RouteSummary.wrap(buildAwsValue())
}
object RouteSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.RouteSummary =
      zio.aws.migrationhubrefactorspaces.model.RouteSummary(
        appendSourcePath.map(value => value),
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        includeChildPaths.map(value => value),
        lastUpdatedTime.map(value => value),
        methods.map(value => value),
        ownerAccountId.map(value => value),
        pathResourceToId.map(value => value),
        routeId.map(value => value),
        routeType.map(value => value),
        serviceId.map(value => value),
        sourcePath.map(value => value),
        state.map(value => value),
        tags.map(value => value)
      )
    def appendSourcePath: Optional[Boolean]
    def applicationId: Optional[ApplicationId]
    def arn: Optional[ResourceArn]
    def createdByAccountId: Optional[AccountId]
    def createdTime: Optional[Timestamp]
    def environmentId: Optional[EnvironmentId]
    def error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def includeChildPaths: Optional[Boolean]
    def lastUpdatedTime: Optional[Timestamp]
    def methods
        : Optional[List[zio.aws.migrationhubrefactorspaces.model.HttpMethod]]
    def ownerAccountId: Optional[AccountId]
    def pathResourceToId
        : Optional[Map[PathResourceToIdKey, PathResourceToIdValue]]
    def routeId: Optional[RouteId]
    def routeType: Optional[zio.aws.migrationhubrefactorspaces.model.RouteType]
    def serviceId: Optional[ServiceId]
    def sourcePath: Optional[UriPath]
    def state: Optional[zio.aws.migrationhubrefactorspaces.model.RouteState]
    def tags: Optional[Map[TagMapKeyString, TagMapValueString]]
    def getAppendSourcePath: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("appendSourcePath", appendSourcePath)
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getIncludeChildPaths: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeChildPaths", includeChildPaths)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getMethods: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.HttpMethod
    ]] = AwsError.unwrapOptionField("methods", methods)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getPathResourceToId
        : ZIO[Any, AwsError, Map[PathResourceToIdKey, PathResourceToIdValue]] =
      AwsError.unwrapOptionField("pathResourceToId", pathResourceToId)
    def getRouteId: ZIO[Any, AwsError, RouteId] =
      AwsError.unwrapOptionField("routeId", routeId)
    def getRouteType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteType
    ] = AwsError.unwrapOptionField("routeType", routeType)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getSourcePath: ZIO[Any, AwsError, UriPath] =
      AwsError.unwrapOptionField("sourcePath", sourcePath)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummary
  ) extends zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly {
    override val appendSourcePath: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.appendSourcePath())
      .map(value => value: Boolean)
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val includeChildPaths: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeChildPaths())
      .map(value => value: Boolean)
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val methods
        : Optional[List[zio.aws.migrationhubrefactorspaces.model.HttpMethod]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.methods())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhubrefactorspaces.model.HttpMethod.wrap(item)
          }.toList
        )
    override val ownerAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val pathResourceToId
        : Optional[Map[PathResourceToIdKey, PathResourceToIdValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathResourceToId())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhubrefactorspaces.model.primitives
                .PathResourceToIdKey(
                  key
                ) -> zio.aws.migrationhubrefactorspaces.model.primitives
                .PathResourceToIdValue(value)
            })
            .toMap
        )
    override val routeId: Optional[RouteId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.RouteId(value)
      )
    override val routeType
        : Optional[zio.aws.migrationhubrefactorspaces.model.RouteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeType())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.RouteType.wrap(value)
        )
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val sourcePath: Optional[UriPath] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePath())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.UriPath(value)
      )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.RouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.RouteState.wrap(value)
        )
    override val tags: Optional[Map[TagMapKeyString, TagMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapKeyString(
                  key
                ) -> zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapValueString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummary
  ): zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly =
    new Wrapper(impl)
}
