package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.UriPath
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UriPathRouteInput(
    activationState: zio.aws.migrationhubrefactorspaces.model.RouteActivationState,
    includeChildPaths: Optional[Boolean] = Optional.Absent,
    methods: Optional[
      Iterable[zio.aws.migrationhubrefactorspaces.model.HttpMethod]
    ] = Optional.Absent,
    sourcePath: UriPath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.UriPathRouteInput = {
    import UriPathRouteInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UriPathRouteInput
      .builder()
      .activationState(activationState.unwrap)
      .optionallyWith(includeChildPaths.map(value => value: java.lang.Boolean))(
        _.includeChildPaths
      )
      .optionallyWith(
        methods.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.methodsWithStrings)
      .sourcePath(UriPath.unwrap(sourcePath): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput
      .wrap(buildAwsValue())
}
object UriPathRouteInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UriPathRouteInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput =
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput(
        activationState,
        includeChildPaths.map(value => value),
        methods.map(value => value),
        sourcePath
      )
    def activationState
        : zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    def includeChildPaths: Optional[Boolean]
    def methods
        : Optional[List[zio.aws.migrationhubrefactorspaces.model.HttpMethod]]
    def sourcePath: UriPath
    def getActivationState: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
    ] = ZIO.succeed(activationState)
    def getIncludeChildPaths: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeChildPaths", includeChildPaths)
    def getMethods: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.HttpMethod
    ]] = AwsError.unwrapOptionField("methods", methods)
    def getSourcePath: ZIO[Any, Nothing, UriPath] = ZIO.succeed(sourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UriPathRouteInput
  ) extends zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly {
    override val activationState
        : zio.aws.migrationhubrefactorspaces.model.RouteActivationState =
      zio.aws.migrationhubrefactorspaces.model.RouteActivationState
        .wrap(impl.activationState())
    override val includeChildPaths: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeChildPaths())
      .map(value => value: Boolean)
    override val methods
        : Optional[List[zio.aws.migrationhubrefactorspaces.model.HttpMethod]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.methods())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhubrefactorspaces.model.HttpMethod.wrap(item)
          }.toList
        )
    override val sourcePath: UriPath =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .UriPath(impl.sourcePath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UriPathRouteInput
  ): zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly =
    new Wrapper(impl)
}
