package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.Uri
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UrlEndpointSummary(
    healthUrl: Optional[Uri] = Optional.Absent,
    url: Optional[Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointSummary = {
    import UrlEndpointSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointSummary
      .builder()
      .optionallyWith(
        healthUrl.map(value => Uri.unwrap(value): java.lang.String)
      )(_.healthUrl)
      .optionallyWith(url.map(value => Uri.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.UrlEndpointSummary.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.UrlEndpointSummary
      .wrap(buildAwsValue())
}
object UrlEndpointSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.UrlEndpointSummary =
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointSummary(
        healthUrl.map(value => value),
        url.map(value => value)
      )
    def healthUrl: Optional[Uri]
    def url: Optional[Uri]
    def getHealthUrl: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("healthUrl", healthUrl)
    def getUrl: ZIO[Any, AwsError, Uri] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointSummary
  ) extends zio.aws.migrationhubrefactorspaces.model.UrlEndpointSummary.ReadOnly {
    override val healthUrl: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.healthUrl())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Uri(value)
      )
    override val url: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Uri(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointSummary
  ): zio.aws.migrationhubrefactorspaces.model.UrlEndpointSummary.ReadOnly =
    new Wrapper(impl)
}
