package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId
import scala.jdk.CollectionConverters._
final case class GetEnvironmentRequest(environmentIdentifier: EnvironmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentRequest = {
    import GetEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentRequest
      .builder()
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest
      .wrap(buildAwsValue())
}
object GetEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest =
      zio.aws.migrationhubrefactorspaces.model
        .GetEnvironmentRequest(environmentIdentifier)
    def environmentIdentifier: EnvironmentId
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest.ReadOnly {
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetEnvironmentRequest
  ): zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
