package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  TagMapKeyString,
  ApplicationName,
  AccountId,
  Timestamp,
  EnvironmentId,
  ResourceArn,
  TagMapValueString,
  ApplicationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    apiGatewayProxy: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary
    ] = Optional.Absent,
    applicationId: Optional[ApplicationId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent,
    createdByAccountId: Optional[AccountId] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    error: Optional[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    name: Optional[ApplicationName] = Optional.Absent,
    ownerAccountId: Optional[AccountId] = Optional.Absent,
    proxyType: Optional[zio.aws.migrationhubrefactorspaces.model.ProxyType] =
      Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.ApplicationState] =
      Optional.Absent,
    tags: Optional[Map[TagMapKeyString, TagMapValueString]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
      .builder()
      .optionallyWith(apiGatewayProxy.map(value => value.buildAwsValue()))(
        _.apiGatewayProxy
      )
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(proxyType.map(value => value.unwrap))(_.proxyType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ApplicationSummary
      .wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ApplicationSummary =
      zio.aws.migrationhubrefactorspaces.model.ApplicationSummary(
        apiGatewayProxy.map(value => value.asEditable),
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        ownerAccountId.map(value => value),
        proxyType.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        vpcId.map(value => value)
      )
    def apiGatewayProxy: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly
    ]
    def applicationId: Optional[ApplicationId]
    def arn: Optional[ResourceArn]
    def createdByAccountId: Optional[AccountId]
    def createdTime: Optional[Timestamp]
    def environmentId: Optional[EnvironmentId]
    def error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def lastUpdatedTime: Optional[Timestamp]
    def name: Optional[ApplicationName]
    def ownerAccountId: Optional[AccountId]
    def proxyType: Optional[zio.aws.migrationhubrefactorspaces.model.ProxyType]
    def state
        : Optional[zio.aws.migrationhubrefactorspaces.model.ApplicationState]
    def tags: Optional[Map[TagMapKeyString, TagMapValueString]]
    def vpcId: Optional[VpcId]
    def getApiGatewayProxy: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly
    ] = AwsError.unwrapOptionField("apiGatewayProxy", apiGatewayProxy)
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getProxyType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ProxyType
    ] = AwsError.unwrapOptionField("proxyType", proxyType)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApplicationState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
  ) extends zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly {
    override val apiGatewayProxy: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.apiGatewayProxy())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary
          .wrap(value)
      )
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Optional[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .ApplicationName(value)
      )
    override val ownerAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val proxyType
        : Optional[zio.aws.migrationhubrefactorspaces.model.ProxyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxyType())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ProxyType.wrap(value)
        )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.ApplicationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.ApplicationState.wrap(value)
        )
    override val tags: Optional[Map[TagMapKeyString, TagMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapKeyString(
                  key
                ) -> zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapValueString(value)
            })
            .toMap
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApplicationSummary
  ): zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly =
    new Wrapper(impl)
}
