package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationsResponse(
    applicationSummaryList: Optional[
      Iterable[zio.aws.migrationhubrefactorspaces.model.ApplicationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListApplicationsResponse
      .builder()
      .optionallyWith(
        applicationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse
      .wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse =
      zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse(
        applicationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applicationSummaryList: Optional[
      List[zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getApplicationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "applicationSummaryList",
      applicationSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListApplicationsResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly {
    override val applicationSummaryList: Optional[
      List[zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListApplicationsResponse
  ): zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
