package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  EnvironmentName,
  Timestamp,
  EnvironmentId,
  ResourceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeleteEnvironmentResponse(
    arn: Optional[ResourceArn] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    name: Optional[EnvironmentName] = Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.EnvironmentState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentResponse = {
    import DeleteEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentResponse
      .builder()
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse
      .wrap(buildAwsValue())
}
object DeleteEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse =
      zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse(
        arn.map(value => value),
        environmentId.map(value => value),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def arn: Optional[ResourceArn]
    def environmentId: Optional[EnvironmentId]
    def lastUpdatedTime: Optional[Timestamp]
    def name: Optional[EnvironmentName]
    def state
        : Optional[zio.aws.migrationhubrefactorspaces.model.EnvironmentState]
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.EnvironmentState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly {
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val name: Optional[EnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives
          .EnvironmentName(value)
      )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.EnvironmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.EnvironmentState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.DeleteEnvironmentResponse
  ): zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
