package zio.aws.migrationhubrefactorspaces
import zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.{
  DeleteRouteResponse,
  DeleteRouteRequest,
  ListRoutesRequest,
  GetResourcePolicyResponse,
  GetEnvironmentRequest,
  GetServiceResponse,
  PutResourcePolicyResponse,
  DeleteApplicationRequest,
  ListEnvironmentsRequest,
  DeleteServiceRequest,
  ListRoutesResponse,
  GetEnvironmentResponse,
  ListEnvironmentVpcsRequest,
  PutResourcePolicyRequest,
  CreateRouteResponse,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  CreateRouteRequest,
  ServiceSummary,
  ListEnvironmentVpcsResponse,
  CreateServiceResponse,
  DeleteServiceResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateServiceRequest,
  GetRouteRequest,
  ListApplicationsResponse,
  GetApplicationRequest,
  CreateApplicationResponse,
  DeleteResourcePolicyRequest,
  GetServiceRequest,
  UntagResourceRequest,
  EnvironmentVpc,
  ListApplicationsRequest,
  ListServicesRequest,
  RouteSummary,
  CreateEnvironmentRequest,
  DeleteEnvironmentRequest,
  GetResourcePolicyRequest,
  DeleteResourcePolicyResponse,
  GetRouteResponse,
  TagResourceResponse,
  ApplicationSummary,
  GetApplicationResponse,
  ListEnvironmentsResponse,
  EnvironmentSummary,
  CreateEnvironmentResponse,
  DeleteApplicationResponse,
  TagResourceRequest,
  DeleteEnvironmentResponse,
  ListServicesResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.migrationhubrefactorspaces.{
  MigrationHubRefactorSpacesAsyncClientBuilder,
  MigrationHubRefactorSpacesAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait MigrationHubRefactorSpaces
    extends AspectSupport[MigrationHubRefactorSpaces] {
  val api: MigrationHubRefactorSpacesAsyncClient
  def deleteEnvironment(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly
  ]
  def getApplication(
      request: zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetApplicationResponse.ReadOnly
  ]
  def deleteApplication(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly
  ]
  def createRoute(
      request: zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly
  ]
  def deleteRoute(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteRouteRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly
  ]
  def createService(
      request: zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateServiceResponse.ReadOnly
  ]
  def createEnvironment(
      request: zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentResponse.ReadOnly
  ]
  def getEnvironment(
      request: zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly
  ]
  def createApplication(
      request: zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateApplicationResponse.ReadOnly
  ]
  def listRoutes(
      request: zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly
  ]
  def listRoutesPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly
  ]
  def deleteService(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly
  ]
  def listServices(
      request: zio.aws.migrationhubrefactorspaces.model.ListServicesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly
  ]
  def listServicesPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListServicesRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly
  ]
  def putResourcePolicy(
      request: zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyResponse.ReadOnly
  ]
  def listEnvironmentVpcs(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly
  ]
  def listEnvironmentVpcsPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
  ): IO[AwsError, ReadOnly]
  def listEnvironments(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly
  ]
  def listEnvironmentsPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.migrationhubrefactorspaces.model.UntagResourceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.UntagResourceResponse.ReadOnly
  ]
  def getRoute(
      request: zio.aws.migrationhubrefactorspaces.model.GetRouteRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly
  ]
  def deleteResourcePolicy(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse.ReadOnly
  ]
  def getService(
      request: zio.aws.migrationhubrefactorspaces.model.GetServiceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.migrationhubrefactorspaces.model.TagResourceRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.TagResourceResponse.ReadOnly
  ]
  def listApplications(
      request: zio.aws.migrationhubrefactorspaces.model.ListApplicationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly
  ]
  def listApplicationsPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListApplicationsRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly
  ]
  def getResourcePolicy(
      request: zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly
  ]
}
object MigrationHubRefactorSpaces {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MigrationHubRefactorSpaces] =
    customized(identity)
  def customized(
      customization: MigrationHubRefactorSpacesAsyncClientBuilder => MigrationHubRefactorSpacesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MigrationHubRefactorSpaces] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MigrationHubRefactorSpacesAsyncClientBuilder => MigrationHubRefactorSpacesAsyncClientBuilder
  ): ZIO[
    AwsConfig with Scope,
    java.lang.Throwable,
    MigrationHubRefactorSpaces
  ] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MigrationHubRefactorSpacesAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      MigrationHubRefactorSpacesAsyncClient,
      MigrationHubRefactorSpacesAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      MigrationHubRefactorSpacesAsyncClient,
      MigrationHubRefactorSpacesAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new MigrationHubRefactorSpacesImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MigrationHubRefactorSpacesImpl[R](
      override val api: MigrationHubRefactorSpacesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MigrationHubRefactorSpaces
      with AwsServiceBase[R] {
    override val serviceName: String = "MigrationHubRefactorSpaces"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MigrationHubRefactorSpacesImpl[R1] =
      new MigrationHubRefactorSpacesImpl(api, newAspect, r)
    def deleteEnvironment(
        request: zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEnvironmentRequest,
      DeleteEnvironmentResponse
    ]("deleteEnvironment", api.deleteEnvironment)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.wrap
      )
      .provideEnvironment(r)
    def getApplication(
        request: zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.GetApplicationResponse.ReadOnly
    ] = asyncRequestResponse[GetApplicationRequest, GetApplicationResponse](
      "getApplication",
      api.getApplication
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.GetApplicationResponse.wrap)
      .provideEnvironment(r)
    def deleteApplication(
        request: zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.wrap
      )
      .provideEnvironment(r)
    def createRoute(
        request: zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly
    ] = asyncRequestResponse[CreateRouteRequest, CreateRouteResponse](
      "createRoute",
      api.createRoute
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.wrap)
      .provideEnvironment(r)
    def deleteRoute(
        request: zio.aws.migrationhubrefactorspaces.model.DeleteRouteRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly
    ] = asyncRequestResponse[DeleteRouteRequest, DeleteRouteResponse](
      "deleteRoute",
      api.deleteRoute
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.wrap)
      .provideEnvironment(r)
    def createService(
        request: zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.CreateServiceResponse.ReadOnly
    ] = asyncRequestResponse[CreateServiceRequest, CreateServiceResponse](
      "createService",
      api.createService
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.CreateServiceResponse.wrap)
      .provideEnvironment(r)
    def createEnvironment(
        request: zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEnvironmentRequest,
      CreateEnvironmentResponse
    ]("createEnvironment", api.createEnvironment)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentResponse.wrap
      )
      .provideEnvironment(r)
    def getEnvironment(
        request: zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[GetEnvironmentRequest, GetEnvironmentResponse](
      "getEnvironment",
      api.getEnvironment
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def createApplication(
        request: zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.CreateApplicationResponse.wrap
      )
      .provideEnvironment(r)
    def listRoutes(
        request: zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListRoutesRequest,
      ListRoutesResponse,
      RouteSummary
    ](
      "listRoutes",
      api.listRoutes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.routeSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhubrefactorspaces.model.RouteSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listRoutesPaginated(
        request: zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly
    ] = asyncRequestResponse[ListRoutesRequest, ListRoutesResponse](
      "listRoutes",
      api.listRoutes
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.wrap)
      .provideEnvironment(r)
    def deleteService(
        request: zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly
    ] = asyncRequestResponse[DeleteServiceRequest, DeleteServiceResponse](
      "deleteService",
      api.deleteService
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.wrap)
      .provideEnvironment(r)
    def listServices(
        request: zio.aws.migrationhubrefactorspaces.model.ListServicesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListServicesRequest,
      ListServicesResponse,
      ServiceSummary
    ](
      "listServices",
      api.listServices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.serviceSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhubrefactorspaces.model.ServiceSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listServicesPaginated(
        request: zio.aws.migrationhubrefactorspaces.model.ListServicesRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly
    ] = asyncRequestResponse[ListServicesRequest, ListServicesResponse](
      "listServices",
      api.listServices
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.wrap)
      .provideEnvironment(r)
    def putResourcePolicy(
        request: zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      PutResourcePolicyRequest,
      PutResourcePolicyResponse
    ]("putResourcePolicy", api.putResourcePolicy)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyResponse.wrap
      )
      .provideEnvironment(r)
    def listEnvironmentVpcs(
        request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListEnvironmentVpcsRequest,
      ListEnvironmentVpcsResponse,
      EnvironmentVpc
    ](
      "listEnvironmentVpcs",
      api.listEnvironmentVpcs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.environmentVpcList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.wrap(item)
      )
      .provideEnvironment(r)
    def listEnvironmentVpcsPaginated(
        request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListEnvironmentVpcsRequest,
      ListEnvironmentVpcsResponse
    ]("listEnvironmentVpcs", api.listEnvironmentVpcs)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse.wrap
      )
      .provideEnvironment(r)
    def listEnvironments(
        request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListEnvironmentsRequest,
      ListEnvironmentsResponse,
      EnvironmentSummary
    ](
      "listEnvironments",
      api.listEnvironments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.environmentSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listEnvironmentsPaginated(
        request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[ListEnvironmentsRequest, ListEnvironmentsResponse](
      "listEnvironments",
      api.listEnvironments
    )(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.migrationhubrefactorspaces.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getRoute(
        request: zio.aws.migrationhubrefactorspaces.model.GetRouteRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly
    ] = asyncRequestResponse[GetRouteRequest, GetRouteResponse](
      "getRoute",
      api.getRoute
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcePolicy(
        request: zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse.wrap
      )
      .provideEnvironment(r)
    def getService(
        request: zio.aws.migrationhubrefactorspaces.model.GetServiceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly
    ] = asyncRequestResponse[GetServiceRequest, GetServiceResponse](
      "getService",
      api.getService
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.migrationhubrefactorspaces.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.migrationhubrefactorspaces.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def listApplications(
        request: zio.aws.migrationhubrefactorspaces.model.ListApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListApplicationsRequest,
      ListApplicationsResponse,
      ApplicationSummary
    ](
      "listApplications",
      api.listApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listApplicationsPaginated(
        request: zio.aws.migrationhubrefactorspaces.model.ListApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[ListApplicationsRequest, ListApplicationsResponse](
      "listApplications",
      api.listApplications
    )(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.wrap
      )
      .provideEnvironment(r)
    def getResourcePolicy(
        request: zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetResourcePolicyRequest,
      GetResourcePolicyResponse
    ]("getResourcePolicy", api.getResourcePolicy)(request.buildAwsValue())
      .map(
        zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.wrap
      )
      .provideEnvironment(r)
  }
  def deleteEnvironment(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def getApplication(
      request: zio.aws.migrationhubrefactorspaces.model.GetApplicationRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def deleteApplication(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteApplicationRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def createRoute(
      request: zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoute(request))
  def deleteRoute(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteRouteRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRoute(request))
  def createService(
      request: zio.aws.migrationhubrefactorspaces.model.CreateServiceRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createService(request))
  def createEnvironment(
      request: zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironment(request))
  def getEnvironment(
      request: zio.aws.migrationhubrefactorspaces.model.GetEnvironmentRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def createApplication(
      request: zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def listRoutes(
      request: zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest
  ): ZStream[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listRoutes(request))
  def listRoutesPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListRoutesRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoutesPaginated(request))
  def deleteService(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteServiceRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteService(request))
  def listServices(
      request: zio.aws.migrationhubrefactorspaces.model.ListServicesRequest
  ): ZStream[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listServices(request))
  def listServicesPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListServicesRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServicesPaginated(request))
  def putResourcePolicy(
      request: zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def listEnvironmentVpcs(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
  ): ZStream[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironmentVpcs(request))
  def listEnvironmentVpcsPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentVpcsPaginated(request))
  def listEnvironments(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsRequest
  ): ZStream[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironments(request))
  def listEnvironmentsPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentsPaginated(request))
  def untagResource(
      request: zio.aws.migrationhubrefactorspaces.model.UntagResourceRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getRoute(
      request: zio.aws.migrationhubrefactorspaces.model.GetRouteRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoute(request))
  def deleteResourcePolicy(
      request: zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def getService(
      request: zio.aws.migrationhubrefactorspaces.model.GetServiceRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getService(request))
  def listTagsForResource(
      request: zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.migrationhubrefactorspaces.model.TagResourceRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(
      request: zio.aws.migrationhubrefactorspaces.model.ListApplicationsRequest
  ): ZStream[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(
      request: zio.aws.migrationhubrefactorspaces.model.ListApplicationsRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def getResourcePolicy(
      request: zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest
  ): ZIO[
    zio.aws.migrationhubrefactorspaces.MigrationHubRefactorSpaces,
    AwsError,
    zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicy(request))
}
