package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.StageName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApiGatewayProxyInput(
    endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = Optional.Absent,
    stageName: Optional[StageName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput = {
    import ApiGatewayProxyInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
      .builder()
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput
      .wrap(buildAwsValue())
}
object ApiGatewayProxyInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput =
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput(
        endpointType.map(value => value),
        stageName.map(value => value)
      )
    def endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ]
    def stageName: Optional[StageName]
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
  ) extends zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly {
    override val endpointType: Optional[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
          .wrap(value)
      )
    override val stageName: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.StageName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
  ): zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly =
    new Wrapper(impl)
}
