package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.ResourcePolicyIdentifier
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyRequest(
    identifier: ResourcePolicyIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyRequest = {
    import GetResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyRequest
      .builder()
      .identifier(ResourcePolicyIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest
      .wrap(buildAwsValue())
}
object GetResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest =
      zio.aws.migrationhubrefactorspaces.model
        .GetResourcePolicyRequest(identifier)
    def identifier: ResourcePolicyIdentifier
    def getIdentifier: ZIO[Any, Nothing, ResourcePolicyIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest.ReadOnly {
    override val identifier: ResourcePolicyIdentifier =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ResourcePolicyIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyRequest
  ): zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
