package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  TagMapKeyString,
  EnvironmentId,
  ClientToken,
  TagMapValueString,
  ApplicationId
}
import scala.jdk.CollectionConverters._
final case class CreateRouteRequest(
    applicationIdentifier: ApplicationId,
    clientToken: Option[ClientToken] = None,
    environmentIdentifier: EnvironmentId,
    routeType: zio.aws.migrationhubrefactorspaces.model.RouteType,
    serviceIdentifier: ServiceId,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None,
    uriPathRoute: Option[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteRequest = {
    import CreateRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .routeType(routeType.unwrap)
      .serviceIdentifier(ServiceId.unwrap(serviceIdentifier): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(uriPathRoute.map(value => value.buildAwsValue()))(
        _.uriPathRoute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest
      .wrap(buildAwsValue())
}
object CreateRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest =
      zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest(
        applicationIdentifier,
        clientToken.map(value => value),
        environmentIdentifier,
        routeType,
        serviceIdentifier,
        tags.map(value => value),
        uriPathRoute.map(value => value.asEditable)
      )
    def applicationIdentifier: ApplicationId
    def clientToken: Option[ClientToken]
    def environmentIdentifier: EnvironmentId
    def routeType: zio.aws.migrationhubrefactorspaces.model.RouteType
    def serviceIdentifier: ServiceId
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def uriPathRoute: Option[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ]
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getRouteType: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhubrefactorspaces.model.RouteType
    ] = ZIO.succeed(routeType)
    def getServiceIdentifier: ZIO[Any, Nothing, ServiceId] =
      ZIO.succeed(serviceIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUriPathRoute: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ] = AwsError.unwrapOptionField("uriPathRoute", uriPathRoute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ClientToken(value)
      )
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val routeType: zio.aws.migrationhubrefactorspaces.model.RouteType =
      zio.aws.migrationhubrefactorspaces.model.RouteType.wrap(impl.routeType())
    override val serviceIdentifier: ServiceId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ServiceId(impl.serviceIdentifier())
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
    override val uriPathRoute: Option[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ] = scala
      .Option(impl.uriPathRoute())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteRequest
  ): zio.aws.migrationhubrefactorspaces.model.CreateRouteRequest.ReadOnly =
    new Wrapper(impl)
}
