package zio.aws.migrationhubrefactorspaces.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  NextToken,
  MaxResults,
  EnvironmentId
}
import scala.jdk.CollectionConverters._
final case class ListEnvironmentVpcsRequest(
    environmentIdentifier: EnvironmentId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest = {
    import ListEnvironmentVpcsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
      .builder()
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
      .wrap(buildAwsValue())
}
object ListEnvironmentVpcsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest =
      zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest(
        environmentIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def environmentIdentifier: EnvironmentId
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest.ReadOnly {
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
  ): zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest.ReadOnly =
    new Wrapper(impl)
}
