package zio.aws.migrationhubrefactorspaces.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  NextToken,
  MaxResults,
  EnvironmentId,
  ApplicationId
}
import scala.jdk.CollectionConverters._
final case class ListServicesRequest(
    applicationIdentifier: ApplicationId,
    environmentIdentifier: EnvironmentId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesRequest = {
    import ListServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesRequest
      .builder()
      .applicationIdentifier(
        ApplicationId.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListServicesRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListServicesRequest
      .wrap(buildAwsValue())
}
object ListServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListServicesRequest =
      zio.aws.migrationhubrefactorspaces.model.ListServicesRequest(
        applicationIdentifier,
        environmentIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def applicationIdentifier: ApplicationId
    def environmentIdentifier: EnvironmentId
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getApplicationIdentifier: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.ListServicesRequest.ReadOnly {
    override val applicationIdentifier: ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationId(impl.applicationIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListServicesRequest
  ): zio.aws.migrationhubrefactorspaces.model.ListServicesRequest.ReadOnly =
    new Wrapper(impl)
}
