package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  TagMapKeyString,
  AccountId,
  Timestamp,
  PathResourceToIdValue,
  PathResourceToIdKey,
  EnvironmentId,
  ResourceArn,
  TagMapValueString,
  RouteId,
  ApplicationId,
  UriPath
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetRouteResponse(
    applicationId: Option[ApplicationId] = None,
    arn: Option[ResourceArn] = None,
    createdByAccountId: Option[AccountId] = None,
    createdTime: Option[Timestamp] = None,
    environmentId: Option[EnvironmentId] = None,
    error: Option[zio.aws.migrationhubrefactorspaces.model.ErrorResponse] =
      None,
    includeChildPaths: Option[Boolean] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    methods: Option[
      Iterable[zio.aws.migrationhubrefactorspaces.model.HttpMethod]
    ] = None,
    ownerAccountId: Option[AccountId] = None,
    pathResourceToId: Option[Map[PathResourceToIdKey, PathResourceToIdValue]] =
      None,
    routeId: Option[RouteId] = None,
    routeType: Option[zio.aws.migrationhubrefactorspaces.model.RouteType] =
      None,
    serviceId: Option[ServiceId] = None,
    sourcePath: Option[UriPath] = None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.RouteState] = None,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteResponse = {
    import GetRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(includeChildPaths.map(value => value: java.lang.Boolean))(
        _.includeChildPaths
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        methods.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.methodsWithStrings)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        pathResourceToId.map(value =>
          value
            .map({ case (key, value) =>
              (PathResourceToIdKey.unwrap(
                key
              ): java.lang.String) -> (PathResourceToIdValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.pathResourceToId)
      .optionallyWith(
        routeId.map(value => RouteId.unwrap(value): java.lang.String)
      )(_.routeId)
      .optionallyWith(routeType.map(value => value.unwrap))(_.routeType)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(
        sourcePath.map(value => UriPath.unwrap(value): java.lang.String)
      )(_.sourcePath)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetRouteResponse
      .wrap(buildAwsValue())
}
object GetRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.GetRouteResponse =
      zio.aws.migrationhubrefactorspaces.model.GetRouteResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        environmentId.map(value => value),
        error.map(value => value.asEditable),
        includeChildPaths.map(value => value),
        lastUpdatedTime.map(value => value),
        methods.map(value => value),
        ownerAccountId.map(value => value),
        pathResourceToId.map(value => value),
        routeId.map(value => value),
        routeType.map(value => value),
        serviceId.map(value => value),
        sourcePath.map(value => value),
        state.map(value => value),
        tags.map(value => value)
      )
    def applicationId: Option[ApplicationId]
    def arn: Option[ResourceArn]
    def createdByAccountId: Option[AccountId]
    def createdTime: Option[Timestamp]
    def environmentId: Option[EnvironmentId]
    def error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ]
    def includeChildPaths: Option[Boolean]
    def lastUpdatedTime: Option[Timestamp]
    def methods
        : Option[List[zio.aws.migrationhubrefactorspaces.model.HttpMethod]]
    def ownerAccountId: Option[AccountId]
    def pathResourceToId
        : Option[Map[PathResourceToIdKey, PathResourceToIdValue]]
    def routeId: Option[RouteId]
    def routeType: Option[zio.aws.migrationhubrefactorspaces.model.RouteType]
    def serviceId: Option[ServiceId]
    def sourcePath: Option[UriPath]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.RouteState]
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getIncludeChildPaths: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeChildPaths", includeChildPaths)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getMethods: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.HttpMethod
    ]] = AwsError.unwrapOptionField("methods", methods)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getPathResourceToId
        : ZIO[Any, AwsError, Map[PathResourceToIdKey, PathResourceToIdValue]] =
      AwsError.unwrapOptionField("pathResourceToId", pathResourceToId)
    def getRouteId: ZIO[Any, AwsError, RouteId] =
      AwsError.unwrapOptionField("routeId", routeId)
    def getRouteType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteType
    ] = AwsError.unwrapOptionField("routeType", routeType)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getSourcePath: ZIO[Any, AwsError, UriPath] =
      AwsError.unwrapOptionField("sourcePath", sourcePath)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Option[AccountId] = scala
      .Option(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val environmentId: Option[EnvironmentId] = scala
      .Option(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val error: Option[
      zio.aws.migrationhubrefactorspaces.model.ErrorResponse.ReadOnly
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ErrorResponse.wrap(value)
      )
    override val includeChildPaths: Option[Boolean] =
      scala.Option(impl.includeChildPaths()).map(value => value: Boolean)
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val methods
        : Option[List[zio.aws.migrationhubrefactorspaces.model.HttpMethod]] =
      scala
        .Option(impl.methods())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhubrefactorspaces.model.HttpMethod.wrap(item)
          }.toList
        )
    override val ownerAccountId: Option[AccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val pathResourceToId
        : Option[Map[PathResourceToIdKey, PathResourceToIdValue]] = scala
      .Option(impl.pathResourceToId())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives
              .PathResourceToIdKey(
                key
              ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .PathResourceToIdValue(value)
          })
          .toMap
      )
    override val routeId: Option[RouteId] = scala
      .Option(impl.routeId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.RouteId(value)
      )
    override val routeType
        : Option[zio.aws.migrationhubrefactorspaces.model.RouteType] = scala
      .Option(impl.routeType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.RouteType.wrap(value)
      )
    override val serviceId: Option[ServiceId] = scala
      .Option(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val sourcePath: Option[UriPath] = scala
      .Option(impl.sourcePath())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.UriPath(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.RouteState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.RouteState.wrap(value)
      )
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetRouteResponse
  ): zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly =
    new Wrapper(impl)
}
