package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.StageName
import scala.jdk.CollectionConverters._
final case class ApiGatewayProxyInput(
    endpointType: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = None,
    stageName: Option[StageName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput = {
    import ApiGatewayProxyInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
      .builder()
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput
      .wrap(buildAwsValue())
}
object ApiGatewayProxyInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput =
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput(
        endpointType.map(value => value),
        stageName.map(value => value)
      )
    def endpointType: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ]
    def stageName: Option[StageName]
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
  ) extends zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly {
    override val endpointType: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = scala
      .Option(impl.endpointType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
          .wrap(value)
      )
    override val stageName: Option[StageName] = scala
      .Option(impl.stageName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.StageName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
  ): zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly =
    new Wrapper(impl)
}
