package zio.aws.migrationhubrefactorspaces
import zio.prelude.Subtype
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  AdditionalDetailsValue,
  TagMapKeyString,
  PathResourceToIdValue,
  PathResourceToIdKey,
  CidrBlock,
  AdditionalDetailsKey,
  TagMapValueString
}
import java.time.Instant
import zio.aws.migrationhubrefactorspaces.model.primitives.AdditionalDetailsValue.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId =
      zio.aws.migrationhubrefactorspaces.model.primitives.AccountId.Type
    object AdditionalDetailsKey extends Subtype[String]
    type AdditionalDetailsKey =
      zio.aws.migrationhubrefactorspaces.model.primitives.AdditionalDetailsKey.Type
    object AdditionalDetailsValue extends Subtype[String]
    type AdditionalDetailsValue =
      zio.aws.migrationhubrefactorspaces.model.primitives.AdditionalDetailsValue.Type
    object ApiGatewayId extends Subtype[String]
    type ApiGatewayId =
      zio.aws.migrationhubrefactorspaces.model.primitives.ApiGatewayId.Type
    object ApplicationId extends Subtype[String]
    type ApplicationId =
      zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId.Type
    object ApplicationName extends Subtype[String]
    type ApplicationName =
      zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationName.Type
    object CidrBlock extends Subtype[String]
    type CidrBlock =
      zio.aws.migrationhubrefactorspaces.model.primitives.CidrBlock.Type
    object ClientToken extends Subtype[String]
    type ClientToken =
      zio.aws.migrationhubrefactorspaces.model.primitives.ClientToken.Type
    object Description extends Subtype[String]
    type Description =
      zio.aws.migrationhubrefactorspaces.model.primitives.Description.Type
    object Ec2TagValue extends Subtype[String]
    type Ec2TagValue =
      zio.aws.migrationhubrefactorspaces.model.primitives.Ec2TagValue.Type
    object EnvironmentId extends Subtype[String]
    type EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId.Type
    object EnvironmentName extends Subtype[String]
    type EnvironmentName =
      zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentName.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage =
      zio.aws.migrationhubrefactorspaces.model.primitives.ErrorMessage.Type
    object LambdaArn extends Subtype[String]
    type LambdaArn =
      zio.aws.migrationhubrefactorspaces.model.primitives.LambdaArn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults =
      zio.aws.migrationhubrefactorspaces.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken =
      zio.aws.migrationhubrefactorspaces.model.primitives.NextToken.Type
    object NlbArn extends Subtype[String]
    type NlbArn =
      zio.aws.migrationhubrefactorspaces.model.primitives.NlbArn.Type
    object NlbName extends Subtype[String]
    type NlbName =
      zio.aws.migrationhubrefactorspaces.model.primitives.NlbName.Type
    object PathResourceToIdKey extends Subtype[String]
    type PathResourceToIdKey =
      zio.aws.migrationhubrefactorspaces.model.primitives.PathResourceToIdKey.Type
    object PathResourceToIdValue extends Subtype[String]
    type PathResourceToIdValue =
      zio.aws.migrationhubrefactorspaces.model.primitives.PathResourceToIdValue.Type
    object PolicyString extends Subtype[String]
    type PolicyString =
      zio.aws.migrationhubrefactorspaces.model.primitives.PolicyString.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn =
      zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.migrationhubrefactorspaces.model.primitives.ResourceIdentifier.Type
    object ResourcePolicyIdentifier extends Subtype[String]
    type ResourcePolicyIdentifier =
      zio.aws.migrationhubrefactorspaces.model.primitives.ResourcePolicyIdentifier.Type
    object RouteId extends Subtype[String]
    type RouteId =
      zio.aws.migrationhubrefactorspaces.model.primitives.RouteId.Type
    object ServiceId extends Subtype[String]
    type ServiceId =
      zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId.Type
    object ServiceName extends Subtype[String]
    type ServiceName =
      zio.aws.migrationhubrefactorspaces.model.primitives.ServiceName.Type
    object StageName extends Subtype[String]
    type StageName =
      zio.aws.migrationhubrefactorspaces.model.primitives.StageName.Type
    object TagMapKeyString extends Subtype[String]
    type TagMapKeyString =
      zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString.Type
    object TagMapValueString extends Subtype[String]
    type TagMapValueString =
      zio.aws.migrationhubrefactorspaces.model.primitives.TagMapValueString.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp =
      zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp.Type
    object TransitGatewayId extends Subtype[String]
    type TransitGatewayId =
      zio.aws.migrationhubrefactorspaces.model.primitives.TransitGatewayId.Type
    object Uri extends Subtype[String]
    type Uri = zio.aws.migrationhubrefactorspaces.model.primitives.Uri.Type
    object UriPath extends Subtype[String]
    type UriPath =
      zio.aws.migrationhubrefactorspaces.model.primitives.UriPath.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.migrationhubrefactorspaces.model.primitives.VpcId.Type
    object VpcLinkId extends Subtype[String]
    type VpcLinkId =
      zio.aws.migrationhubrefactorspaces.model.primitives.VpcLinkId.Type
  }
  type AdditionalDetails = Map[AdditionalDetailsKey, AdditionalDetailsValue]
  type ApplicationSummaries =
    List[zio.aws.migrationhubrefactorspaces.model.ApplicationSummary]
  type CidrBlocks = List[CidrBlock]
  type EnvironmentSummaries =
    List[zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary]
  type EnvironmentVpcs =
    List[zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc]
  type HttpMethods = List[zio.aws.migrationhubrefactorspaces.model.HttpMethod]
  type PathResourceToId = Map[PathResourceToIdKey, PathResourceToIdValue]
  type RouteSummaries =
    List[zio.aws.migrationhubrefactorspaces.model.RouteSummary]
  type ServiceSummaries =
    List[zio.aws.migrationhubrefactorspaces.model.ServiceSummary]
  type TagKeys = List[String]
  type TagMap = Map[TagMapKeyString, TagMapValueString]
}
