package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  TagMapKeyString,
  AccountId,
  Timestamp,
  ResourceArn,
  TagMapValueString,
  RouteId,
  ApplicationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateRouteResponse(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    arn: Optional[ResourceArn] = Optional.Absent,
    createdByAccountId: Optional[AccountId] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    ownerAccountId: Optional[AccountId] = Optional.Absent,
    routeId: Optional[RouteId] = Optional.Absent,
    routeType: Optional[zio.aws.migrationhubrefactorspaces.model.RouteType] =
      Optional.Absent,
    serviceId: Optional[ServiceId] = Optional.Absent,
    state: Optional[zio.aws.migrationhubrefactorspaces.model.RouteState] =
      Optional.Absent,
    tags: Optional[Map[TagMapKeyString, TagMapValueString]] = Optional.Absent,
    uriPathRoute: Optional[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse = {
    import CreateRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        routeId.map(value => RouteId.unwrap(value): java.lang.String)
      )(_.routeId)
      .optionallyWith(routeType.map(value => value.unwrap))(_.routeType)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(uriPathRoute.map(value => value.buildAwsValue()))(
        _.uriPathRoute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse
      .wrap(buildAwsValue())
}
object CreateRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse =
      zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        lastUpdatedTime.map(value => value),
        ownerAccountId.map(value => value),
        routeId.map(value => value),
        routeType.map(value => value),
        serviceId.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        uriPathRoute.map(value => value.asEditable)
      )
    def applicationId: Optional[ApplicationId]
    def arn: Optional[ResourceArn]
    def createdByAccountId: Optional[AccountId]
    def createdTime: Optional[Timestamp]
    def lastUpdatedTime: Optional[Timestamp]
    def ownerAccountId: Optional[AccountId]
    def routeId: Optional[RouteId]
    def routeType: Optional[zio.aws.migrationhubrefactorspaces.model.RouteType]
    def serviceId: Optional[ServiceId]
    def state: Optional[zio.aws.migrationhubrefactorspaces.model.RouteState]
    def tags: Optional[Map[TagMapKeyString, TagMapValueString]]
    def uriPathRoute: Optional[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getRouteId: ZIO[Any, AwsError, RouteId] =
      AwsError.unwrapOptionField("routeId", routeId)
    def getRouteType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteType
    ] = AwsError.unwrapOptionField("routeType", routeType)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUriPathRoute: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ] = AwsError.unwrapOptionField("uriPathRoute", uriPathRoute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val ownerAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val routeId: Optional[RouteId] = zio.aws.core.internal
      .optionalFromNullable(impl.routeId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.RouteId(value)
      )
    override val routeType
        : Optional[zio.aws.migrationhubrefactorspaces.model.RouteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeType())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.RouteType.wrap(value)
        )
    override val serviceId: Optional[ServiceId] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Optional[zio.aws.migrationhubrefactorspaces.model.RouteState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.migrationhubrefactorspaces.model.RouteState.wrap(value)
        )
    override val tags: Optional[Map[TagMapKeyString, TagMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapKeyString(
                  key
                ) -> zio.aws.migrationhubrefactorspaces.model.primitives
                .TagMapValueString(value)
            })
            .toMap
        )
    override val uriPathRoute: Optional[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.uriPathRoute())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
  ): zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly =
    new Wrapper(impl)
}
