package zio.aws.migrationhubrefactorspaces.model
import scala.jdk.CollectionConverters._
sealed trait ApiGatewayEndpointType {
  def unwrap: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType
}
object ApiGatewayEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType
  ): zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType =
    value match {
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType.REGIONAL =>
        val r = REGIONAL
        r
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType.PRIVATE =>
        val r = PRIVATE
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object REGIONAL
      extends zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType.REGIONAL
  }
  case object PRIVATE
      extends zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType.PRIVATE
  }
}
