package zio.aws.migrationhubrefactorspaces.model
import scala.jdk.CollectionConverters._
sealed trait ServiceEndpointType {
  def unwrap: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType
}
object ServiceEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType
  ): zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType =
    value match {
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType.LAMBDA =>
        val r = LAMBDA
        r
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType.URL =>
        val r = URL
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object LAMBDA
      extends zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType.LAMBDA
  }
  case object URL
      extends zio.aws.migrationhubrefactorspaces.model.ServiceEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.ServiceEndpointType.URL
  }
}
