package zio.aws.migrationhubrefactorspaces.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  AccountId,
  Timestamp,
  Ec2TagValue,
  CidrBlock,
  EnvironmentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class EnvironmentVpc(
    accountId: Optional[AccountId] = Optional.Absent,
    cidrBlocks: Optional[Iterable[CidrBlock]] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    environmentId: Optional[EnvironmentId] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    vpcName: Optional[Ec2TagValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc = {
    import EnvironmentVpc.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        cidrBlocks.map(value =>
          value.map { item =>
            CidrBlock.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.cidrBlocks)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        environmentId.map(value =>
          EnvironmentId.unwrap(value): java.lang.String
        )
      )(_.environmentId)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        vpcName.map(value => Ec2TagValue.unwrap(value): java.lang.String)
      )(_.vpcName)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc
      .wrap(buildAwsValue())
}
object EnvironmentVpc {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc =
      zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc(
        accountId.map(value => value),
        cidrBlocks.map(value => value),
        createdTime.map(value => value),
        environmentId.map(value => value),
        lastUpdatedTime.map(value => value),
        vpcId.map(value => value),
        vpcName.map(value => value)
      )
    def accountId: Optional[AccountId]
    def cidrBlocks: Optional[List[CidrBlock]]
    def createdTime: Optional[Timestamp]
    def environmentId: Optional[EnvironmentId]
    def lastUpdatedTime: Optional[Timestamp]
    def vpcId: Optional[VpcId]
    def vpcName: Optional[Ec2TagValue]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCidrBlocks: ZIO[Any, AwsError, List[CidrBlock]] =
      AwsError.unwrapOptionField("cidrBlocks", cidrBlocks)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnvironmentId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("environmentId", environmentId)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcName: ZIO[Any, AwsError, Ec2TagValue] =
      AwsError.unwrapOptionField("vpcName", vpcName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
  ) extends zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val cidrBlocks: Optional[List[CidrBlock]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhubrefactorspaces.model.primitives.CidrBlock(item)
        }.toList
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val environmentId: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.EnvironmentId(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(value)
      )
    override val vpcName: Optional[Ec2TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Ec2TagValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.EnvironmentVpc
  ): zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly =
    new Wrapper(impl)
}
