package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.LambdaArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaEndpointConfig(
    arn: Optional[LambdaArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointConfig = {
    import LambdaEndpointConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointConfig
      .builder()
      .optionallyWith(
        arn.map(value => LambdaArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig
      .wrap(buildAwsValue())
}
object LambdaEndpointConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig =
      zio.aws.migrationhubrefactorspaces.model
        .LambdaEndpointConfig(arn.map(value => value))
    def arn: Optional[LambdaArn]
    def getArn: ZIO[Any, AwsError, LambdaArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointConfig
  ) extends zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly {
    override val arn: Optional[LambdaArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.LambdaArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.LambdaEndpointConfig
  ): zio.aws.migrationhubrefactorspaces.model.LambdaEndpointConfig.ReadOnly =
    new Wrapper(impl)
}
