package zio.aws.migrationhubrefactorspaces
import zio.aws.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.migrationhubrefactorspaces.MigrationHubRefactorSpacesAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.migrationhubrefactorspaces.model.{
  DeleteRouteRequest,
  ListRoutesRequest,
  GetEnvironmentRequest,
  DeleteApplicationRequest,
  ListEnvironmentsRequest,
  DeleteServiceRequest,
  ListEnvironmentVpcsRequest,
  PutResourcePolicyRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  CreateRouteRequest,
  CreateServiceRequest,
  GetRouteRequest,
  UpdateRouteRequest,
  GetApplicationRequest,
  DeleteResourcePolicyRequest,
  GetServiceRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  ListServicesRequest,
  CreateEnvironmentRequest,
  DeleteEnvironmentRequest,
  GetResourcePolicyRequest,
  TagResourceRequest
}
object MigrationHubRefactorSpacesMock extends Mock[MigrationHubRefactorSpaces] {
  object DeleteEnvironment
      extends Effect[
        DeleteEnvironmentRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly
      ]
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.GetApplicationResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly
      ]
  object CreateRoute
      extends Effect[
        CreateRouteRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly
      ]
  object DeleteRoute
      extends Effect[
        DeleteRouteRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly
      ]
  object UpdateRoute
      extends Effect[
        UpdateRouteRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse.ReadOnly
      ]
  object CreateService
      extends Effect[
        CreateServiceRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.CreateServiceResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[
        CreateEnvironmentRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentResponse.ReadOnly
      ]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.CreateApplicationResponse.ReadOnly
      ]
  object ListRoutes
      extends Stream[
        ListRoutesRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly
      ]
  object ListRoutesPaginated
      extends Effect[
        ListRoutesRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly
      ]
  object DeleteService
      extends Effect[
        DeleteServiceRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly
      ]
  object ListServices
      extends Stream[
        ListServicesRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly
      ]
  object ListServicesPaginated
      extends Effect[
        ListServicesRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyResponse.ReadOnly
      ]
  object ListEnvironmentVpcs
      extends Stream[
        ListEnvironmentVpcsRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly
      ]
  object ListEnvironmentVpcsPaginated
      extends Effect[ListEnvironmentVpcsRequest, AwsError, ReadOnly]
  object ListEnvironments
      extends Stream[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly
      ]
  object ListEnvironmentsPaginated
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.UntagResourceResponse.ReadOnly
      ]
  object GetRoute
      extends Effect[
        GetRouteRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object GetService
      extends Effect[
        GetServiceRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.TagResourceResponse.ReadOnly
      ]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly
      ]
  object GetResourcePolicy
      extends Effect[
        GetResourcePolicyRequest,
        AwsError,
        zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MigrationHubRefactorSpaces] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, MigrationHubRefactorSpaces] { rts =>
        zio.ZIO.succeed {
          new MigrationHubRefactorSpaces {
            val api: MigrationHubRefactorSpacesAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): MigrationHubRefactorSpaces = this
            def deleteEnvironment(request: DeleteEnvironmentRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.DeleteEnvironmentResponse.ReadOnly
            ] = proxy(DeleteEnvironment, request)
            def getApplication(request: GetApplicationRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.GetApplicationResponse.ReadOnly
            ] = proxy(GetApplication, request)
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def createRoute(request: CreateRouteRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly
            ] = proxy(CreateRoute, request)
            def deleteRoute(request: DeleteRouteRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.DeleteRouteResponse.ReadOnly
            ] = proxy(DeleteRoute, request)
            def updateRoute(request: UpdateRouteRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.UpdateRouteResponse.ReadOnly
            ] = proxy(UpdateRoute, request)
            def createService(request: CreateServiceRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.CreateServiceResponse.ReadOnly
            ] = proxy(CreateService, request)
            def createEnvironment(request: CreateEnvironmentRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.CreateEnvironmentResponse.ReadOnly
            ] = proxy(CreateEnvironment, request)
            def getEnvironment(request: GetEnvironmentRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.GetEnvironmentResponse.ReadOnly
            ] = proxy(GetEnvironment, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def listRoutes(request: ListRoutesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.RouteSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRoutes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRoutesPaginated(request: ListRoutesRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.ListRoutesResponse.ReadOnly
            ] = proxy(ListRoutesPaginated, request)
            def deleteService(request: DeleteServiceRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.DeleteServiceResponse.ReadOnly
            ] = proxy(DeleteService, request)
            def listServices(request: ListServicesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.ServiceSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListServices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listServicesPaginated(request: ListServicesRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.ListServicesResponse.ReadOnly
            ] = proxy(ListServicesPaginated, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def listEnvironmentVpcs(
                request: ListEnvironmentVpcsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.EnvironmentVpc.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnvironmentVpcs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnvironmentVpcsPaginated(
                request: ListEnvironmentVpcsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListEnvironmentVpcsPaginated, request)
            def listEnvironments(request: ListEnvironmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnvironments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnvironmentsPaginated(request: ListEnvironmentsRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly
            ] = proxy(ListEnvironmentsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getRoute(request: GetRouteRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.GetRouteResponse.ReadOnly
            ] = proxy(GetRoute, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def getService(request: GetServiceRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.GetServiceResponse.ReadOnly
            ] = proxy(GetService, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.ApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def getResourcePolicy(request: GetResourcePolicyRequest): IO[
              AwsError,
              zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly
            ] = proxy(GetResourcePolicy, request)
          }
        }
      }
    }
  }
}
