package zio.aws.migrationhubrefactorspaces.model
import scala.jdk.CollectionConverters._
sealed trait RouteActivationState {
  def unwrap: software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState
}
object RouteActivationState {
  def wrap(
      value: software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState
  ): zio.aws.migrationhubrefactorspaces.model.RouteActivationState =
    value match {
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState.ACTIVE =>
        val r = ACTIVE
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.migrationhubrefactorspaces.model.RouteActivationState {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE
      extends zio.aws.migrationhubrefactorspaces.model.RouteActivationState {
    override def unwrap
        : software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState =
      software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteActivationState.ACTIVE
  }
}
