package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ResourceArn,
  PolicyString
}
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(
    policy: PolicyString,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.PutResourcePolicyRequest
      .builder()
      .policy(PolicyString.unwrap(policy): java.lang.String)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest
      .wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest =
      zio.aws.migrationhubrefactorspaces.model
        .PutResourcePolicyRequest(policy, resourceArn)
    def policy: PolicyString
    def resourceArn: ResourceArn
    def getPolicy: ZIO[Any, Nothing, PolicyString] = ZIO.succeed(policy)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.PutResourcePolicyRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest.ReadOnly {
    override val policy: PolicyString =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .PolicyString(impl.policy())
    override val resourceArn: ResourceArn =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.PutResourcePolicyRequest
  ): zio.aws.migrationhubrefactorspaces.model.PutResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
