package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  TagMapValueString,
  TagMapKeyString
}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: String,
    tags: Map[TagMapKeyString, TagMapValueString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagMapKeyString
              .unwrap(key): java.lang.String) -> (TagMapValueString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.TagResourceRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.TagResourceRequest =
      zio.aws.migrationhubrefactorspaces.model
        .TagResourceRequest(resourceArn, tags)
    def resourceArn: String
    def tags: Map[TagMapKeyString, TagMapValueString]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagMapKeyString, TagMapValueString]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagResourceRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.TagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tags: Map[TagMapKeyString, TagMapValueString] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
          key
        ) -> zio.aws.migrationhubrefactorspaces.model.primitives
          .TagMapValueString(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.TagResourceRequest
  ): zio.aws.migrationhubrefactorspaces.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
