package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  VpcId,
  TagMapKeyString,
  ApplicationName,
  EnvironmentId,
  ClientToken,
  TagMapValueString
}
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    apiGatewayProxy: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput
    ] = None,
    clientToken: Option[ClientToken] = None,
    environmentIdentifier: EnvironmentId,
    name: ApplicationName,
    proxyType: zio.aws.migrationhubrefactorspaces.model.ProxyType,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateApplicationRequest
      .builder()
      .optionallyWith(apiGatewayProxy.map(value => value.buildAwsValue()))(
        _.apiGatewayProxy
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .name(ApplicationName.unwrap(name): java.lang.String)
      .proxyType(proxyType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest
      .wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest =
      zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest(
        apiGatewayProxy.map(value => value.asEditable),
        clientToken.map(value => value),
        environmentIdentifier,
        name,
        proxyType,
        tags.map(value => value),
        vpcId
      )
    def apiGatewayProxy: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly
    ]
    def clientToken: Option[ClientToken]
    def environmentIdentifier: EnvironmentId
    def name: ApplicationName
    def proxyType: zio.aws.migrationhubrefactorspaces.model.ProxyType
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def vpcId: VpcId
    def getApiGatewayProxy: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly
    ] = AwsError.unwrapOptionField("apiGatewayProxy", apiGatewayProxy)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getName: ZIO[Any, Nothing, ApplicationName] = ZIO.succeed(name)
    def getProxyType: ZIO[
      Any,
      Nothing,
      zio.aws.migrationhubrefactorspaces.model.ProxyType
    ] = ZIO.succeed(proxyType)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateApplicationRequest
  ) extends zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest.ReadOnly {
    override val apiGatewayProxy: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput.ReadOnly
    ] = scala
      .Option(impl.apiGatewayProxy())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxyInput
          .wrap(value)
      )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ClientToken(value)
      )
    override val environmentIdentifier: EnvironmentId =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val name: ApplicationName =
      zio.aws.migrationhubrefactorspaces.model.primitives
        .ApplicationName(impl.name())
    override val proxyType: zio.aws.migrationhubrefactorspaces.model.ProxyType =
      zio.aws.migrationhubrefactorspaces.model.ProxyType.wrap(impl.proxyType())
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
    override val vpcId: VpcId =
      zio.aws.migrationhubrefactorspaces.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateApplicationRequest
  ): zio.aws.migrationhubrefactorspaces.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
