package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsResponse(
    environmentSummaryList: Option[
      Iterable[zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse
      .builder()
      .optionallyWith(
        environmentSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse
      .wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse =
      zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse(
        environmentSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def environmentSummaryList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getEnvironmentSummaryList: ZIO[Any, AwsError, List[
      zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "environmentSummaryList",
      environmentSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly {
    override val environmentSummaryList: Option[
      List[zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.ReadOnly]
    ] = scala
      .Option(impl.environmentSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhubrefactorspaces.model.EnvironmentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse
  ): zio.aws.migrationhubrefactorspaces.model.ListEnvironmentsResponse.ReadOnly =
    new Wrapper(impl)
}
