package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.PolicyString
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyResponse(
    policy: Option[PolicyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => PolicyString.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse
      .wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse =
      zio.aws.migrationhubrefactorspaces.model
        .GetResourcePolicyResponse(policy.map(value => value))
    def policy: Option[PolicyString]
    def getPolicy: ZIO[Any, AwsError, PolicyString] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly {
    override val policy: Option[PolicyString] = scala
      .Option(impl.policy())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.PolicyString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.GetResourcePolicyResponse
  ): zio.aws.migrationhubrefactorspaces.model.GetResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
