package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.Uri
import scala.jdk.CollectionConverters._
final case class UrlEndpointConfig(
    healthUrl: Option[Uri] = None,
    url: Option[Uri] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointConfig = {
    import UrlEndpointConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointConfig
      .builder()
      .optionallyWith(
        healthUrl.map(value => Uri.unwrap(value): java.lang.String)
      )(_.healthUrl)
      .optionallyWith(url.map(value => Uri.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig
      .wrap(buildAwsValue())
}
object UrlEndpointConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig =
      zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig(
        healthUrl.map(value => value),
        url.map(value => value)
      )
    def healthUrl: Option[Uri]
    def url: Option[Uri]
    def getHealthUrl: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("healthUrl", healthUrl)
    def getUrl: ZIO[Any, AwsError, Uri] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointConfig
  ) extends zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly {
    override val healthUrl: Option[Uri] = scala
      .Option(impl.healthUrl())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Uri(value)
      )
    override val url: Option[Uri] = scala
      .Option(impl.url())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Uri(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.UrlEndpointConfig
  ): zio.aws.migrationhubrefactorspaces.model.UrlEndpointConfig.ReadOnly =
    new Wrapper(impl)
}
